/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.FrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.client.MobHeadShadersManager;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonController;
import net.mehvahdjukaar.supplementaries.client.hud.SelectableContainerItemHud;
import net.mehvahdjukaar.supplementaries.client.renderers.CapturedMobCache;
import net.mehvahdjukaar.supplementaries.client.screens.ConfigButton;
import net.mehvahdjukaar.supplementaries.client.screens.WelcomeMessageScreen;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractRopeBlock;
import net.mehvahdjukaar.supplementaries.common.entities.IPartyCreeper;
import net.mehvahdjukaar.supplementaries.common.events.overrides.InteractEventsHandler;
import net.mehvahdjukaar.supplementaries.common.events.overrides.SuppAdditionalPlacement;
import net.mehvahdjukaar.supplementaries.common.network.SyncEquippedQuiverPacket;
import net.mehvahdjukaar.supplementaries.common.network.SyncPartyCreeperPacket;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1011;
import net.minecraft.class_1087;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1547;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_7417;
import net.minecraft.class_744;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class ClientEvents {
    protected static final class_5250 PLACEABLE_TOOLTIP = class_2561.method_43471((String)"message.supplementaries.placeable").method_27692(class_124.field_1063).method_27692(class_124.field_1056);
    private static boolean isOnRope;
    private static boolean preventShiftTillNextKeyUp;

    public static void onItemTooltip(class_1799 itemStack, class_1792.class_9635 tooltipContext, class_1836 tooltipFlag, List<class_2561> components) {
        class_1792 item;
        if (ClientConfigs.General.TOOLTIP_HINTS.get().booleanValue()) {
            InteractEventsHandler.addOverrideTooltips(itemStack, tooltipFlag, components);
        }
        if (ClientConfigs.General.PLACEABLE_TOOLTIP.get().booleanValue() && AdditionalItemPlacementsAPI.getBehavior((class_1792)itemStack.method_7909()) instanceof SuppAdditionalPlacement) {
            components.add((class_2561)PLACEABLE_TOOLTIP);
        }
        if ((item = itemStack.method_7909()) == ModRegistry.ROPE_ARROW_ITEM.get() || item == ModRegistry.BUBBLE_BLOWER.get()) {
            Optional<class_2561> r = components.stream().filter(t -> {
                class_2588 tc;
                class_7417 patt0$temp = t.method_10851();
                return patt0$temp instanceof class_2588 && (tc = (class_2588)patt0$temp).method_11022().equals("item.durability");
            }).findFirst();
            r.ifPresent(components::remove);
        }
    }

    public static void addConfigButton(class_437 screen, List<? extends class_364> listeners, Consumer<class_364> adder) {
        if (ClientConfigs.General.CONFIG_BUTTON.get().booleanValue()) {
            ConfigButton.setupConfigButton(screen, listeners, adder);
        }
    }

    public static void onFirstScreen(class_437 screen) {
        class_437 newScreen = screen;
        if (CompatHandler.OPTIFINE) {
            boolean disabled = ClientConfigs.General.NO_OPTIFINE_WARN.get();
            Random random = new Random();
            if (random.nextFloat() < 0.05f) {
                SuppPlatformStuff.disableOFWarn(false);
                boolean bl = disabled = !disabled;
            }
            if (!disabled) {
                newScreen = WelcomeMessageScreen.createOptifine(newScreen);
            }
        }
        if (!CompatHandler.AMENDMENTS && !ClientConfigs.General.NO_AMENDMENTS_WARN.get().booleanValue()) {
            newScreen = WelcomeMessageScreen.createAmendments(newScreen);
        }
        if (!ClientConfigs.General.NO_INCOMPATIBLE_MODS.get().booleanValue() && WelcomeMessageScreen.hasIncompat() && !PlatHelper.isDev()) {
            newScreen = WelcomeMessageScreen.createIncompatibleMods(newScreen);
        }
        if (newScreen != screen) {
            class_310.method_1551().method_1507(newScreen);
        }
    }

    public static void generateIcons() {
        if (!PlatHelper.isDev() || class_310.method_1551().field_1687 == null) {
            return;
        }
        if (class_310.method_1551().field_1687.method_8510() % 400L != 0L) {
            return;
        }
        if (class_310.method_1551().field_1687 != null) {
            class_3300 res = class_310.method_1551().method_1478();
            try {
                TextureImage plus = TextureImage.open((class_3300)res, (class_2960)Supplementaries.res("plus"));
                TextureImage unseen = TextureImage.open((class_3300)res, (class_2960)Supplementaries.res("unseen"));
                HashSet<class_1792> items = new HashSet<class_1792>();
                items.add(ModRegistry.PLANTER.get().method_8389());
                items.add(ModRegistry.PEDESTAL.get().method_8389());
                for (class_1792 item : items) {
                    class_2960 id = Utils.getID((class_1792)item);
                    ClientEvents.makeTexture("", item, new TextureImage[0]);
                    ClientEvents.makeTexture("_unseen", item, unseen);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static FrameBufferBackedDynamicTexture requestFlatItemTexture(class_2960 id, class_1792 item, int size, @Nullable Consumer<class_1011> postProcessing, boolean updateEachFrame) {
        return RenderedTexturesManager.requestTexture((class_2960)id, (int)size, t -> {
            RenderedTexturesManager.drawAsInGUI((FrameBufferBackedDynamicTexture)t, g -> {
                g.method_51448().method_46416(8.0f, 8.0f, 0.0f);
                g.method_51448().method_22905(0.8888889f, 0.8888889f, 1.0f);
                g.method_51448().method_46416(-8.0f, -8.0f, 0.0f);
                g.method_51445(item.method_7854(), 0, 0);
            });
            if (postProcessing != null) {
                t.download();
                class_1011 img = t.getPixels();
                postProcessing.accept(img);
                t.upload();
            }
        }, (boolean)updateEachFrame);
    }

    private static void makeTexture(String postfix, class_1792 item, TextureImage ... overlays) {
        class_1087 model = class_310.method_1551().method_1480().method_4019(item.method_7854(), null, null, 0);
        int s = model.method_4712() ? 16 : 1;
        FrameBufferBackedDynamicTexture t = ClientEvents.requestFlatItemTexture(Utils.getID((class_1792)item).method_48331(postfix), item, 18 * s, nativeImage -> {
            SpriteUtils.forEachPixel((class_1011)nativeImage, (x, y) -> {
                if (y < nativeImage.method_4323() / 2) {
                    return;
                }
                int currentColor = nativeImage.method_4315(x.intValue(), y.intValue());
                int oppositeYColor = nativeImage.method_4315(x.intValue(), nativeImage.method_4323() - 1 - y);
                nativeImage.method_4305(x.intValue(), y.intValue(), oppositeYColor);
                nativeImage.method_4305(x.intValue(), nativeImage.method_4323() - 1 - y, currentColor);
            });
            ClientEvents.addOutline(nativeImage, class_5253.class_8045.method_48343((int)255, (int)0), s);
            for (TextureImage plus : overlays) {
                SpriteUtils.forEachPixel((class_1011)nativeImage, (x, y) -> {
                    int xx = -1 + x / s;
                    int yy = -1 + y / s;
                    if (xx >= plus.getImage().method_4307() || yy >= plus.getImage().method_4323() || xx < 0 || yy < 0) {
                        return;
                    }
                    int color = plus.getImage().method_4315(xx, yy);
                    if (color != 0) {
                        nativeImage.method_4305(x.intValue(), y.intValue(), color);
                    }
                });
            }
        }, false);
        if (t.isInitialized()) {
            try {
                t.saveTextureToFile(PlatHelper.getGamePath().resolve("guide"));
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error((Object)e);
            }
        }
    }

    private static void addOutline(class_1011 nativeImage, int color, int thickness) {
        int[][] temp = new int[nativeImage.method_4307()][nativeImage.method_4323()];
        SpriteUtils.forEachPixel((class_1011)nativeImage, (x, y) -> {
            int currentColor = nativeImage.method_4315(x.intValue(), y.intValue());
            if (class_5253.class_8045.method_48342((int)currentColor) != 0) {
                for (int i = -thickness; i <= thickness; ++i) {
                    for (int j = -thickness; j <= thickness; ++j) {
                        int currentColor2;
                        if (i * i + j * j > thickness * thickness || x + i < 0 || x + i >= nativeImage.method_4307() || y + j < 0 || y + j >= nativeImage.method_4323() || class_5253.class_8045.method_48342((int)(currentColor2 = nativeImage.method_4315(x + i, y + j))) != 0) continue;
                        temp[x.intValue() + i][y.intValue() + j] = color;
                    }
                }
            }
        });
        for (int x2 = 0; x2 < nativeImage.method_4307(); ++x2) {
            for (int y2 = 0; y2 < nativeImage.method_4323(); ++y2) {
                if (temp[x2][y2] == 0) continue;
                nativeImage.method_4305(x2, y2, temp[x2][y2]);
            }
        }
    }

    public static void onClientTick(class_310 minecraft) {
        if (minecraft.method_1493() || minecraft.field_1687 == null) {
            return;
        }
        CapturedMobCache.tickCrystal();
        class_746 p = minecraft.field_1724;
        if (p == null) {
            return;
        }
        ClientEvents.checkIfOnRope((class_1657)p);
        MobHeadShadersManager.INSTANCE.applyMobHeadShaders((class_1657)p, minecraft);
        CannonController.onClientTick(minecraft);
    }

    public static boolean isIsOnRope() {
        return isOnRope;
    }

    private static void checkIfOnRope(class_1657 p) {
        AbstractRopeBlock rb;
        class_2248 class_22482;
        class_2680 state = p.method_25936();
        isOnRope = (p.method_23317() != p.field_6038 || p.method_23321() != p.field_5989) && (class_22482 = state.method_26204()) instanceof AbstractRopeBlock && !(rb = (AbstractRopeBlock)class_22482).hasConnection(class_2350.field_11036, state) && (p.method_23318() + 500.0) % 1.0 >= AbstractRopeBlock.COLLISION_SHAPE.method_1105(class_2350.class_2351.field_11052);
    }

    public static void onEntityLoad(class_1297 entity, class_1937 clientLevel) {
        if (entity instanceof class_1547 && entity instanceof IQuiverEntity) {
            IQuiverEntity q = (IQuiverEntity)entity;
            NetworkHelper.sendToServer((class_8710)new SyncEquippedQuiverPacket(entity, q));
        }
        if (entity instanceof IPartyCreeper && entity instanceof class_1548) {
            class_1548 c = (class_1548)entity;
            NetworkHelper.sendToServer((class_8710)new SyncPartyCreeperPacket((class_1309)c));
        }
    }

    public static void onExplosion(class_1927 explosion) {
    }

    public static boolean cancelKeyPress(int key, int scancode, int action, int modifiers) {
        return SelectableContainerItemHud.getInstance().onKeyPressed(key, action, modifiers) || CannonController.onEarlyKeyPress(key, scancode, action, modifiers);
    }

    public static void modifyInputUpdate(class_744 instance, class_746 player) {
        if (CannonController.isActive()) {
            CannonController.onInputUpdate(instance);
            preventShiftTillNextKeyUp = true;
        } else if (preventShiftTillNextKeyUp) {
            if (!instance.field_3903) {
                preventShiftTillNextKeyUp = false;
            } else {
                instance.field_3903 = false;
            }
        }
    }

    static {
        preventShiftTillNextKeyUp = false;
    }
}

